import { system, world, ItemStack, BlockPermutation } from '@minecraft/server';
const eggIndex = {
	"sf_nba:alligator_egg_block": {hatchedMob: "sf_nba:alligator", hatchEvent: "sf_nba:entity_born", crackSound: "sf_nba.ostrichegg.crack", safeMobs: [ "sf_nba:alligator" ]},
	"sf_nba:emperor_penguin_egg_block": {hatchedMob: "sf_nba:emperor_penguin", crackSound: "sf_nba.ostrichegg.crack", safeMobs: [ "sf_nba:emperor_penguin" ]},
	"sf_nba:ostrich_egg_block": {hatchedMob: "sf_nba:ostrich", crackSound: "sf_nba.ostrichegg.crack", safeMobs: [ "sf_nba:ostrich" ]},
	"sf_nba:tortoise_egg_block": {hatchedMob: "sf_nba:tortoise", crackSound: "sf_nba.ostrichegg.crack", safeMobs: [ "sf_nba:tortoise" ]},
	"sf_nba:snail_egg_block": {hatchedMob: "sf_nba:snail", crackSound: "sf_nba.ostrichegg.crack", safeMobs: [ "sf_nba:snail" ]},
	"sf_nba:snake_egg_block": {hatchedMob: "sf_nba:snake", crackSound: "sf_nba.ostrichegg.crack", hatchEvent: "minecraft:entity_spawned", safeMobs: [ "sf_nba:snake", "sf_nba:rattlesnake", "sf_nba:coral_snake" ]},
	"sf_nba:rattlesnake_egg_block": {hatchedMob: "sf_nba:rattlesnake", crackSound: "sf_nba.ostrichegg.crack", hatchEvent: "minecraft:entity_spawned", safeMobs: [ "sf_nba:snake", "sf_nba:rattlesnake", "sf_nba:coral_snake", "sf_nba:cave_snake" ]},
	"sf_nba:coral_snake_egg_block": {hatchedMob: "sf_nba:coral_snake", crackSound: "sf_nba.ostrichegg.crack", hatchEvent: "minecraft:entity_spawned", safeMobs: [ "sf_nba:snake", "sf_nba:rattlesnake", "sf_nba:coral_snake", "sf_nba:cave_snake" ]},
	"sf_nba:cave_snake_egg_block": {hatchedMob: "sf_nba:cave_snake", crackSound: "sf_nba.ostrichegg.crack", hatchEvent: "minecraft:entity_spawned", safeMobs: [ "sf_nba:snake", "sf_nba:rattlesnake", "sf_nba:coral_snake", "sf_nba:cave_snake" ]},
	"sf_nba:bluejay_egg_block": {hatchedMob: "sf_nba:bluejay", hatchEvent: "minecraft:entity_spawned", crackSound: "sf_nba.ostrichegg.crack", safeMobs: [ "sf_nba:bluejay", "sf_nba:cardinal", "sf_nba:canary", "sf_nba:robin", "sf_nba:crow", "sf_nba:raven" ]},
	"sf_nba:cardinal_egg_block": {hatchedMob: "sf_nba:cardinal", hatchEvent: "minecraft:entity_spawned", crackSound: "sf_nba.ostrichegg.crack", safeMobs: [ "sf_nba:bluejay", "sf_nba:cardinal", "sf_nba:canary", "sf_nba:robin", "sf_nba:crow", "sf_nba:raven" ]},
	"sf_nba:canary_egg_block": {hatchedMob: "sf_nba:canary", hatchEvent: "minecraft:entity_spawned", crackSound: "sf_nba.ostrichegg.crack", safeMobs: [ "sf_nba:bluejay", "sf_nba:cardinal", "sf_nba:canary", "sf_nba:robin", "sf_nba:crow", "sf_nba:raven" ]},
	"sf_nba:robin_egg_block": {hatchedMob: "sf_nba:robin", hatchEvent: "minecraft:entity_spawned", crackSound: "sf_nba.ostrichegg.crack", safeMobs: [ "sf_nba:bluejay", "sf_nba:cardinal", "sf_nba:canary", "sf_nba:robin", "sf_nba:crow", "sf_nba:raven" ]},
	"sf_nba:crow_egg_block": {hatchedMob: "sf_nba:crow", hatchEvent: "minecraft:entity_spawned", crackSound: "sf_nba.ostrichegg.crack", safeMobs: [ "sf_nba:bluejay", "sf_nba:cardinal", "sf_nba:canary", "sf_nba:robin", "sf_nba:crow", "sf_nba:raven" ]},
	"sf_nba:raven_egg_block": {hatchedMob: "sf_nba:raven", hatchEvent: "minecraft:entity_spawned", crackSound: "sf_nba.ostrichegg.crack", safeMobs: [ "sf_nba:bluejay", "sf_nba:cardinal", "sf_nba:canary", "sf_nba:robin", "sf_nba:crow", "sf_nba:raven" ]}
}
function three_stage_egg_step(e) {
	if (Math.random() < 0.75) {
		return;
	}
	const block = e.block;
	const growthStage = block?.permutation.getState("sf_nba:growth_stage");
	if (growthStage == 2) {
		block.dimension.spawnEntity(`${eggIndex[block.typeId].hatchedMob}<${eggIndex[block.typeId].hatchEvent ?? "minecraft:entity_born"}>`, block.location);
		block.dimension.playSound(eggIndex[block.typeId].hatchSound ?? "block.turtle_egg.crack", block.location);
		block.setPermutation(BlockPermutation.resolve("minecraft:air"));
	}
	else {
		block.dimension.playSound(eggIndex[block.typeId].crackSound ?? "block.turtle_egg.crack", block.location);
		block.setPermutation(BlockPermutation.resolve(`${block.typeId}`, { "sf_nba:growth_stage": growthStage + 1 }));
	}
}
function one_stage_egg_step(e) {
	if (Math.random() < 0.75) {
		return;
	}
	const block = e.block;
	block.dimension.spawnEntity(`${eggIndex[block.typeId].hatchedMob}<${eggIndex[block.typeId].hatchEvent ?? "minecraft:entity_born"}>`, block.location);
	block.setPermutation(BlockPermutation.resolve("minecraft:air"));
}
function damage_egg(e) {
	const block = e.block;
	const entity = e.entity;
	if ((e.entity.getComponent("minecraft:is_baby") == null) && (!e.entity.isSneaking) && (!eggIndex[block.typeId].safeMobs.includes(entity.typeId))) {
		const durability = block?.permutation.getState("sf_nba:durability");
		if (durability == 1) {
			block.dimension.playSound(eggIndex[block.typeId].breakSound ?? "block.turtle_egg.break", block.location);
			block.setPermutation(BlockPermutation.resolve("minecraft:air"));
		}
		else {
			const states = {};
			if (block.permutation.getState("sf_nba:growth_stage") != null) {
				states["sf_nba:growth_stage"] = block.permutation.getState("sf_nba:growth_stage");
			}
			states["sf_nba:durability"] = durability - 1;
			block.dimension.playSound(eggIndex[block.typeId].crackSound ?? "block.turtle_egg.crack", block.location);
			block.setPermutation(BlockPermutation.resolve(`${block.typeId}`, states));
		}
	}
}
function update_egg(egg) {
	egg.dimension.getBlock(entity.location, BlockPermutation.resolve(`${egg.typeId}_block`));
	egg.remove();
}
export { three_stage_egg_step, one_stage_egg_step, damage_egg }